package net.gofort;
import java.io.*;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
public class Read_GSMaP {
    public static void main(String[] args) {

        int NCOLS = 3600;
        int NROWS = 1200;
        String inFile = "gsmap_gauge.20141217.0000.v7.0001.0.dat";
        String outFile = "test_gsmap_out.asc";
        double DX = 0.1;
        double DY = 0.1;
        double XLLCENTER = 0.05;
        double YLLCENTER = -59.95;
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            ByteBuffer buf = ByteBuffer.allocate(4);
            float[][] meshVal = new float[NCOLS][NROWS];
            for (int j = 0; j < NROWS; j++) {
                for (int i = 0; i < NCOLS; i++) {
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    buf.putFloat(dis.readFloat());
                    buf.order(ByteOrder.BIG_ENDIAN);
                    meshVal[i][j] = buf.getFloat(0);
                    buf.clear();
                }
            }
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
            pw.print("NCOLS   ");
            pw.println(Integer.toString(NCOLS));
            pw.print("NROWS   ");
            pw.println(Integer.toString(NROWS));
            pw.print("XLLCENTER   ");
            pw.println(Double.toString(XLLCENTER));
            pw.print("YLLCENTER   ");
            pw.println(Double.toString(YLLCENTER));
            pw.print("DX   ");
            pw.println(Double.toString(DX));
            pw.print("DY   ");
            pw.println(Double.toString(DY));
            pw.println("NODATA_VALUE  9.999E+20");
            for (int j = 0; j < NROWS; j++) {
                for (int i = 0; i < NCOLS; i++) {
                    pw.print(String.format("%6.2f  ", meshVal[i][j]));
                }
                pw.println();
            }
            pw.flush();
            pw.close();
            dis.close();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}