package net.gofort;
import java.io.*;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Read_JMA_GRD {
    public static void main(String[] args) {

        int NCOLS = 420;
        int NROWS = 600;

        String inFile = "Z__C_RJTD_20190630020000_SRF_GPV_Ggis1km_Prr60lv_Aper10min_ANAL_grib2_cropped_kyushu.grd";
        String outFile = "test_out.asc";

        double DX = 0.0125;
        double DY = 0.008333333333333333;
        double XLLCENTER = 128.0;
        double YLLCENTER = 30.0;

        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            ByteBuffer buf = ByteBuffer.allocate(4);
            float[][] meshVal = new float[NCOLS][NROWS];

            for (int j = 0; j < NROWS; j++) {
                for (int i = 0; i < NCOLS; i++) {
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    buf.putFloat(dis.readFloat());
                    buf.order(ByteOrder.BIG_ENDIAN);
                    meshVal[i][j] = buf.getFloat(0);
                    buf.clear();
                }
            }

            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));

            pw.print("NCOLS   ");
            pw.println(Integer.toString(NCOLS));
            pw.print("NROWS   ");
            pw.println(Integer.toString(NROWS));
            pw.print("XLLCENTER   ");
            pw.println(Double.toString(XLLCENTER));
            pw.print("YLLCENTER   ");
            pw.println(Double.toString(YLLCENTER));
            pw.print("DX   ");
            pw.println(Double.toString(DX));
            pw.print("DY   ");
            pw.println(Double.toString(DY));
            pw.println("NODATA_VALUE  9.999E+20");

            for (int j = NROWS - 1; j >= 0; j--) {
                for (int i = 0; i < NCOLS; i++) {
                    pw.print(String.format("%6.2f  ", meshVal[i][j]));
                }
                pw.println();
            }

            pw.flush();
            pw.close();
            dis.close();

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}