const path = require("path");
const electron = require("electron");
const app = electron.app;
const { BrowserWindow, ipcMain, dialog } = electron;

let mainWindow;

function createWindow() {
  mainWindow = new BrowserWindow();
  mainWindow.loadFile("./simple_geotiff_animation.html");

  mainWindow.on("closed", () => {
    mainWindow = null;
  });
}

app.on("ready", createWindow);

app.on("window-all-closed", () => {
  if (process.platform !== "darwin") {
    app.quit();
  }
});
app.on("activate", () => {
  if (mainWindow === null) {
    createWindow();
  }
});


